/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.modules.editors.gedcomconversion.GedcomVersionConverter;
import genj.gedcom.Entity;
import genj.gedcom.Grammar;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GedcomFiveConverter
implements Runnable {
    private int counter;
    private String stateName;
    private GedcomVersionConverter converter = null;
    protected List<Property> invalidPropsInvalidTags;
    protected List<Property> invalidPropsMultipleTags;
    protected Map<Property, String[]> invalidPropsMissingTags;
    private final Set<String> REPLACED_TAGS_ADDR = new HashSet<String>(Arrays.asList("_EMAIL", "_FAX", "_WWW"));
    private final Set<String> REPLACED_TAGS_NAME = new HashSet<String>(Arrays.asList("_TYPE", "_FONE", "_ROMN"));
    private final Set<String> REPLACED_TAGS_FAMC = new HashSet<String>(Arrays.asList("_STAT"));
    private final Set<String> REPLACED_TAGS_PLAC = new HashSet<String>(Arrays.asList("_MAP", "_FONE", "_ROMN"));
    private final Set<String> REPLACED_TAGS_MAP = new HashSet<String>(Arrays.asList("_LATI", "_LONG"));
    private final Set<String> REPLACED_TAGS_INDI = new HashSet<String>(Arrays.asList("_FACT"));
    private final Set<String> REPLACED_TAGS_EVEN = new HashSet<String>(Arrays.asList("_RESN", "_RELI"));
    private final Set<String> MOVED_TAGS = new HashSet<String>(Arrays.asList("FORM", "TITL"));
    private final Set<String> REMOVED_TAGS = new HashSet<String>(Arrays.asList("BLOB"));
    private final Set<String> EVENTS = new HashSet<String>(Arrays.asList("ANUL", "ADOP", "BAPM", "BARM", "BASM", "BIRT", "BLES", "BURI", "CAST", "CENS", "CENS", "CHR", "CHRA", "CONF", "CREM", "DEAT", "DIV", "DIVF", "DSCR", "EDUC", "EMIG", "ENGA", "EVEN", "FCOM", "GRAD", "IDNO", "IMMI", "MARB", "MARC", "MARL", "MARR", "MARS", "NATI", "NATU", "NCHI", "NMR", "OCCU", "ORDN", "PROB", "PROP", "RELI", "RESI", "RETI", "SSN", "TITL", "WILL"));

    public GedcomFiveConverter(GedcomVersionConverter converter) {
        this.converter = converter;
        this.invalidPropsInvalidTags = new LinkedList<Property>();
        this.invalidPropsMultipleTags = new LinkedList<Property>();
        this.invalidPropsMissingTags = new LinkedHashMap<Property, String[]>();
    }

    public void notifyProgress() {
        this.converter.notifyProgress(this.counter, this.stateName);
    }

    private void setNextStepCounters(int nextInterval, int percentageFrom, int percentageTo, String step) {
        this.counter = this.converter.setNextStepCounters(nextInterval, percentageFrom, percentageTo, step);
        this.stateName = step;
        this.notifyProgress();
    }

    @Override
    public void run() {
        this.getAnomalies(false);
        if (this.converter.upgrade) {
            this.upgradeGedcom();
        } else {
            this.downgradeGedcom();
        }
        this.invalidPropsInvalidTags.clear();
        this.invalidPropsMultipleTags.clear();
        this.invalidPropsMissingTags.clear();
    }

    private void getAnomalies(boolean allowUndescore) {
        List allEntities = this.converter.gedcom.getEntities();
        this.setNextStepCounters(allEntities.size(), 0, 20, "Collecting properties to scan...");
        ArrayList<Property> listOfProperties = new ArrayList<Property>();
        this.notifyProgress();
        for (Entity entity : allEntities) {
            ++this.counter;
            this.notifyProgress();
            if (entity.getTag().equals("HEAD")) continue;
            this.getPropertiesRecursively((Property)entity, listOfProperties);
        }
        this.invalidPropsInvalidTags.clear();
        this.invalidPropsMultipleTags.clear();
        this.invalidPropsMissingTags.clear();
        this.setNextStepCounters(listOfProperties.size(), 20, 70, "Scanning properties to change...");
        for (Property property : listOfProperties) {
            String[] missingTags;
            ++this.counter;
            this.notifyProgress();
            if (this.isInvalidTagPath(this.converter.toGrammar, property, allowUndescore)) {
                this.invalidPropsInvalidTags.add(property);
            }
            if (this.isMultipleSingleton(this.converter.toGrammar, property)) {
                this.invalidPropsMultipleTags.add(property);
            }
            if ((missingTags = this.getMissingKidTags(this.converter.toGrammar, property)).length == 0) continue;
            this.invalidPropsMissingTags.put(property, missingTags);
        }
    }

    private void upgradeGedcom() {
        this.setNextStepCounters(this.invalidPropsInvalidTags.size(), 70, 98, "Changing properties...");
        while (!this.invalidPropsInvalidTags.isEmpty()) {
            String parentTag;
            ++this.counter;
            this.notifyProgress();
            Property prop = (Property)((LinkedList)this.invalidPropsInvalidTags).removeFirst();
            String entityTag = prop.getEntity().getTag();
            String tag = prop.getTag();
            String newTag = tag.substring(1, tag.length());
            Property parent = prop.getParent();
            String string = parentTag = parent != null ? parent.getTag() : "";
            if (this.REPLACED_TAGS_ADDR.contains(tag) && parent.getProperty("ADDR") != null) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_NAME.contains(tag) && parentTag.equals("NAME") && entityTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_FAMC.contains(tag) && parentTag.equals("FAMC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_PLAC.contains(tag) && parentTag.equals("PLAC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_MAP.contains(tag) && (parentTag.equals("MAP") || parentTag.equals("_MAP"))) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_INDI.contains(tag) && parentTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_EVEN.contains(tag) && this.EVENTS.contains(parentTag)) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.MOVED_TAGS.contains(tag) && parentTag.equals("OBJE")) {
                if (!entityTag.equals("OBJE") && tag.equals("TITL")) continue;
                String formValue = prop.getValue();
                Property p = parent.getProperty("FILE");
                if (p == null) {
                    p = parent.addProperty("FILE", "");
                }
                Property newProp = p.addProperty(tag, formValue);
                this.moveSubTree(prop, newProp);
                parent.delProperty(prop);
                for (Property fileProp : parent.getProperties("FILE")) {
                    Property formProp = fileProp.getProperty("FORM");
                    if (formProp == null) {
                        formProp = fileProp.addProperty("FORM", "");
                    }
                    formProp.setValue(formValue);
                }
                continue;
            }
            if (!this.REMOVED_TAGS.contains(tag)) continue;
            this.replaceProperty(prop, parent, "_" + tag);
        }
        LinkedList<Property> listProp = new LinkedList<Property>();
        listProp.addAll(this.invalidPropsMissingTags.keySet());
        while (!listProp.isEmpty()) {
            String[] tags;
            Property property = (Property)listProp.removeFirst();
            for (String tag : tags = this.invalidPropsMissingTags.get(property)) {
                if (property.getProperty(tag) != null) continue;
                property.addProperty(tag, "");
            }
        }
    }

    private void downgradeGedcom() {
        this.setNextStepCounters(this.invalidPropsInvalidTags.size(), 70, 98, "Changing properties...");
        while (!this.invalidPropsInvalidTags.isEmpty()) {
            String parentTag;
            ++this.counter;
            this.notifyProgress();
            Property prop = (Property)((LinkedList)this.invalidPropsInvalidTags).removeFirst();
            String entityTag = prop.getEntity().getTag();
            String tag = prop.getTag();
            String newTag = "_" + tag;
            Property parent = prop.getParent();
            String string = parentTag = parent != null ? parent.getTag() : "";
            if (this.REPLACED_TAGS_ADDR.contains(newTag) && parent.getProperty("ADDR") != null) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_NAME.contains(newTag) && parentTag.equals("NAME") && entityTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_FAMC.contains(newTag) && parentTag.equals("FAMC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_PLAC.contains(newTag) && parentTag.equals("PLAC")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_MAP.contains(newTag) && (parentTag.equals("MAP") || parentTag.equals("_MAP"))) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_INDI.contains(newTag) && parentTag.equals("INDI")) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.REPLACED_TAGS_EVEN.contains(newTag) && this.EVENTS.contains(parentTag)) {
                this.replaceProperty(prop, parent, newTag);
                continue;
            }
            if (this.MOVED_TAGS.contains(tag) && parentTag.equals("FILE")) {
                Property obje = parent.getParent();
                Property newProp = obje.addProperty(tag, prop.getValue());
                this.moveSubTree(prop, newProp);
                parent.delProperty(prop);
                continue;
            }
            if (!this.REMOVED_TAGS.contains(newTag)) continue;
            this.replaceProperty(prop, parent, tag);
        }
        LinkedList<Property> listProp = new LinkedList<Property>();
        listProp.addAll(this.invalidPropsMissingTags.keySet());
        while (!listProp.isEmpty()) {
            String[] tags;
            Property property = (Property)listProp.removeFirst();
            for (String tag : tags = this.invalidPropsMissingTags.get(property)) {
                if (property.getProperty(tag) != null) continue;
                property.addProperty(tag, "");
            }
        }
    }

    private boolean isInvalidTagPath(Grammar toGrammar, Property property, boolean allowUndescore) {
        if (property instanceof PropertyXRef) {
            return false;
        }
        if (allowUndescore && property.getTag().startsWith("_")) {
            return false;
        }
        return !toGrammar.isValid(property.getPath());
    }

    private boolean isMultipleSingleton(Grammar toGrammar, Property property) {
        return toGrammar.getMeta(property.getPath()).isSingleton() && property.getParent().getProperties(property.getTag()).length > 1;
    }

    private String[] getMissingKidTags(Grammar toGrammar, Property parent) {
        MetaProperty[] metas;
        ArrayList<String> listOfTags = new ArrayList<String>();
        MetaProperty meta = toGrammar.getMeta(parent.getPath());
        for (MetaProperty metaChild : metas = meta.getNestedChildren()) {
            String tag = metaChild.getTag();
            if (!metaChild.isRequired() || parent.getProperty(tag) != null) continue;
            listOfTags.add(tag);
        }
        return listOfTags.toArray(new String[listOfTags.size()]);
    }

    public void getPropertiesRecursively(Property parent, List<Property> props) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            props.add(child);
            this.getPropertiesRecursively(child, props);
        }
    }

    private void replaceProperty(Property prop, Property parent, String newTag) {
        Property newProp = parent.addProperty(newTag, prop.getValue());
        this.moveSubTree(prop, newProp);
        parent.delProperty(prop);
        this.invalidPropsInvalidTags.remove(prop);
    }

    private void moveSubTree(Property fromProp, Property toProp) {
        LinkedList<Tab> subtree = new LinkedList<Tab>();
        LinkedList<Tab> removedTabs = new LinkedList<Tab>();
        subtree.add(new Tab(fromProp, null, toProp));
        this.storePropertiesRecursively(fromProp, subtree);
        for (Tab tabElement : subtree) {
            if (tabElement.parentIndex == null) continue;
            Property fromParent = ((Tab)subtree.get((int)tabElement.parentIndex.intValue())).toProp;
            tabElement.setToProp(fromParent.addProperty(tabElement.fromProp.getTag(), tabElement.fromProp.getValue()));
        }
        subtree.remove(0);
        while (!subtree.isEmpty()) {
            removedTabs.clear();
            for (Tab tabElement : subtree) {
                boolean isLeaf = tabElement.fromProp.getNoOfProperties() == 0;
                if (!isLeaf) continue;
                tabElement.fromProp.getParent().delProperty(tabElement.fromProp);
                this.invalidPropsInvalidTags.remove(tabElement.fromProp);
                this.invalidPropsInvalidTags.add(tabElement.toProp);
                removedTabs.add(tabElement);
            }
            subtree.removeAll(removedTabs);
        }
    }

    private void storePropertiesRecursively(Property parent, List<Tab> tree) {
        Property[] children;
        for (Property child : children = parent.getProperties()) {
            tree.add(new Tab(child, this.getParentIndexFromChild(tree, child), null));
            this.storePropertiesRecursively(child, tree);
        }
    }

    private Integer getParentIndexFromChild(List<Tab> tree, Property child) {
        for (Tab tabElement : tree) {
            if (tabElement.fromProp != child.getParent()) continue;
            return tree.indexOf(tabElement);
        }
        return null;
    }

    private class Tab {
        public Property fromProp;
        public Integer parentIndex;
        public Property toProp;

        private Tab(Property fromProp, Integer parentIndex, Property toProp) {
            this.fromProp = fromProp;
            this.parentIndex = parentIndex;
            this.toProp = toProp;
        }

        public void setToProp(Property prop) {
            this.toProp = prop;
        }
    }
}

