/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swing.renderer.shape.swing.shapePart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.swing.Backend;
import org.graphstream.ui.swing.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.view.camera.DefaultCamera2D;

public class Fillable {
    ShapePaint fillPaint = null;
    double theFillPercent = 0.0;
    Color theFillColor = null;
    boolean plainFast = false;

    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, DefaultCamera2D camera) {
        if (this.plainFast) {
            g.setColor(this.theFillColor);
            g.fill(shape);
        } else if (this.fillPaint instanceof ShapePaint.ShapeAreaPaint) {
            g.setPaint(((ShapePaint.ShapeAreaPaint)this.fillPaint).paint(shape, camera.getMetrics().ratioPx2Gu));
            g.fill(shape);
        } else if (this.fillPaint instanceof ShapePaint.ShapeColorPaint) {
            g.setPaint(((ShapePaint.ShapeColorPaint)this.fillPaint).paint(dynColor, optColor));
            g.fill(shape);
        }
    }

    public void fill(Graphics2D g, Shape shape, DefaultCamera2D camera) {
        this.fill(g, this.theFillPercent, this.theFillColor, shape, camera);
    }

    public void configureFillableForGroup(Backend bck, Style style, DefaultCamera2D camera) {
        this.fillPaint = ShapePaint.apply((Style)style);
        if (this.fillPaint instanceof ShapePaint.ShapePlainColorPaint) {
            ShapePaint.ShapePlainColorPaint paint = (ShapePaint.ShapePlainColorPaint)this.fillPaint;
            this.plainFast = true;
            this.theFillColor = paint.color;
            bck.graphics2D().setColor(this.theFillColor);
        } else {
            this.plainFast = false;
        }
    }

    public void configureFillableForElement(Style style, DefaultCamera2D camera, GraphicElement element) {
        if (style.getFillMode() == StyleConstants.FillMode.DYN_PLAIN && element != null) {
            if (element.getAttribute("ui.color") instanceof Number) {
                this.theFillPercent = (Double)((Number)element.getAttribute("ui.color"));
                this.theFillColor = null;
            } else if (element.getAttribute("ui.color") instanceof Color) {
                this.theFillColor = (Color)element.getAttribute("ui.color");
                this.theFillPercent = 0.0;
            } else {
                this.theFillPercent = 0.0;
                this.theFillColor = null;
            }
        } else {
            this.theFillPercent = 0.0;
        }
    }
}

