/*
 * Decompiled with CFR 0.152.
 */
package genj.io.input;

import ancestris.util.swing.FileChooserBuilder;
import genj.io.InputSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileInput
extends InputSource {
    private File file;

    public FileInput(File file) {
        this(file.getName(), file);
    }

    public FileInput(String name, File file) {
        super(name);
        this.file = file;
        this.setLocation(file.getAbsolutePath());
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public InputStream open() throws IOException {
        return new FileInputStream(this.file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileInput)) {
            return false;
        }
        FileInput that = (FileInput)obj;
        return that.file.equals(this.file) && that.getName().equals(this.getName());
    }

    public int hashCode() {
        return this.file.hashCode() * this.getName().hashCode();
    }

    public String toString() {
        return "file name=" + this.getName() + " file=" + this.file.toString();
    }

    @Override
    public String getExtension() {
        return FileChooserBuilder.getExtension(this.file.getName());
    }

    @Override
    public boolean isAvailable() {
        return this.file.exists();
    }
}

