/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.graphstream.graph.Element;

public abstract class AbstractElement
implements Element {
    protected final String id;
    private int index;
    protected Map<String, Object> attributes = null;
    protected ArrayList<String> attributesBeingRemoved = null;

    public AbstractElement(String id) {
        assert (id != null) : "Graph elements cannot have a null identifier";
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    protected abstract void attributeChanged(AttributeChangeEvent var1, String var2, Object var3, Object var4);

    @Override
    public Object getAttribute(String key) {
        Object value;
        if (this.attributes != null && (value = this.attributes.get(key)) != null) {
            return value;
        }
        return null;
    }

    @Override
    public Object getFirstAttributeOf(String ... keys) {
        Object o = null;
        if (this.attributes != null) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                o = this.attributes.get(key);
                if (o != null) {
                    return o;
                }
                ++n2;
            }
        }
        return o;
    }

    @Override
    public <T> T getAttribute(String key, Class<T> clazz) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null && clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }

    @Override
    public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys) {
        Object o = null;
        if (this.attributes == null) {
            return null;
        }
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            o = this.attributes.get(key);
            if (o != null && clazz.isInstance(o)) {
                return clazz.cast(o);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    @Override
    public boolean hasAttribute(String key, Class<?> clazz) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null) {
            return clazz.isInstance(o);
        }
        return false;
    }

    @Override
    public Stream<String> attributeKeys() {
        if (this.attributes == null) {
            return Stream.empty();
        }
        return this.attributes.keySet().stream();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int getAttributeCount() {
        if (this.attributes != null) {
            return this.attributes.size();
        }
        return 0;
    }

    @Override
    public void clearAttributes() {
        if (this.attributes != null) {
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                this.attributeChanged(AttributeChangeEvent.REMOVE, entry.getKey(), entry.getValue(), null);
            }
            this.attributes.clear();
        }
    }

    protected void clearAttributesWithNoEvent() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    @Override
    public void setAttribute(String attribute, Object ... values) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(1);
        }
        Object value = values == null ? null : (values.length == 0 ? Boolean.valueOf(true) : (values.length == 1 ? values[0] : values));
        AttributeChangeEvent event = AttributeChangeEvent.ADD;
        if (this.attributes.containsKey(attribute)) {
            event = AttributeChangeEvent.CHANGE;
        }
        Object oldValue = this.attributes.put(attribute, value);
        this.attributeChanged(event, attribute, oldValue, value);
    }

    @Override
    public void removeAttribute(String attribute) {
        if (this.attributes != null) {
            if (this.attributesBeingRemoved == null) {
                this.attributesBeingRemoved = new ArrayList();
            }
            if (this.attributes.containsKey(attribute) && !this.attributesBeingRemoved.contains(attribute)) {
                this.attributesBeingRemoved.add(attribute);
                this.attributeChanged(AttributeChangeEvent.REMOVE, attribute, this.attributes.get(attribute), null);
                this.attributesBeingRemoved.remove(this.attributesBeingRemoved.size() - 1);
                this.attributes.remove(attribute);
            }
        }
    }

    public static enum AttributeChangeEvent {
        ADD,
        CHANGE,
        REMOVE;

    }
}

