/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.HashMap;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;

public abstract class AnnotatedSink
implements Sink {
    private final EnumMap<SourceBase.ElementType, MethodMap> methods = new EnumMap(SourceBase.ElementType.class);

    protected AnnotatedSink() {
        this.methods.put(SourceBase.ElementType.GRAPH, new MethodMap());
        this.methods.put(SourceBase.ElementType.EDGE, new MethodMap());
        this.methods.put(SourceBase.ElementType.NODE, new MethodMap());
        Method[] ms = this.getClass().getMethods();
        if (ms != null) {
            int i = 0;
            while (i < ms.length) {
                Method m = ms[i];
                Bind b = m.getAnnotation(Bind.class);
                if (b != null) {
                    this.methods.get((Object)b.type()).put(b.value(), m);
                }
                ++i;
            }
        }
    }

    private void invoke(Method m, Object ... args) {
        try {
            m.invoke((Object)this, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.EDGE).get(attribute);
        if (m != null) {
            this.invoke(m, edgeId, attribute, value);
        }
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.EDGE).get(attribute);
        if (m != null) {
            this.invoke(m, edgeId, attribute, newValue);
        }
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.EDGE).get(attribute);
        if (m != null) {
            this.invoke(m, edgeId, attribute, null);
        }
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.GRAPH).get(attribute);
        if (m != null) {
            this.invoke(m, attribute, value);
        }
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.GRAPH).get(attribute);
        if (m != null) {
            this.invoke(m, attribute, newValue);
        }
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.GRAPH).get(attribute);
        if (m != null) {
            this.invoke(m, attribute, null);
        }
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.NODE).get(attribute);
        if (m != null) {
            this.invoke(m, nodeId, attribute, value);
        }
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.NODE).get(attribute);
        if (m != null) {
            this.invoke(m, nodeId, attribute, newValue);
        }
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        Method m = (Method)this.methods.get((Object)SourceBase.ElementType.NODE).get(attribute);
        if (m != null) {
            this.invoke(m, nodeId, attribute, null);
        }
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Bind {
        public String value();

        public SourceBase.ElementType type() default SourceBase.ElementType.GRAPH;
    }

    private static class MethodMap
    extends HashMap<String, Method> {
        private static final long serialVersionUID = 1664854698109523697L;

        private MethodMap() {
        }
    }
}

