/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.sync;

import org.graphstream.stream.sync.SinkTime;

public class SourceTime {
    protected String sourceId;
    protected long currentTimeId;
    protected SinkTime sinkTime;

    public SourceTime() {
        this(0L);
    }

    public SourceTime(long currentTimeId) {
        this(null, currentTimeId, null);
    }

    public SourceTime(String sourceId) {
        this(sourceId, 0L, null);
    }

    public SourceTime(String sourceId, SinkTime sinkTime) {
        this(sourceId, 0L, sinkTime);
    }

    public SourceTime(String sourceId, long currentTimeId) {
        this(sourceId, currentTimeId, null);
    }

    public SourceTime(String sourceId, long currentTimeId, SinkTime sinkTime) {
        this.sourceId = sourceId;
        this.currentTimeId = currentTimeId;
        this.sinkTime = sinkTime;
    }

    public SinkTime getSinkTime() {
        return this.sinkTime;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setSinkTime(SinkTime st) {
        this.sinkTime = st;
    }

    public long newEvent() {
        ++this.currentTimeId;
        if (this.sinkTime != null) {
            this.sinkTime.setTimeFor(this.sourceId, this.currentTimeId);
        }
        return this.currentTimeId;
    }
}

