// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use cairo;
use cairo_sys;
use gdk_pixbuf;
use gdk_sys;
#[cfg(any(feature = "v3_16", feature = "dox"))]
use glib;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use libc;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem;
use std::mem::transmute;
use std::ptr;
#[cfg(any(feature = "v3_24", feature = "dox"))]
use AnchorHints;
use Cursor;
use Device;
use Display;
use DragProtocol;
#[cfg(any(feature = "v3_22", feature = "dox"))]
use DrawingContext;
use Event;
use EventMask;
use FrameClock;
use FullscreenMode;
#[cfg(any(feature = "v3_16", feature = "dox"))]
use GLContext;
use Geometry;
#[cfg(any(feature = "v3_24", feature = "dox"))]
use Gravity;
use InputSource;
use ModifierType;
use Rectangle;
use Screen;
use Visual;
use WMDecoration;
use WMFunction;
use WindowEdge;
use WindowHints;
use WindowState;
use WindowType;
use WindowTypeHint;
use RGBA;

glib_wrapper! {
    pub struct Window(Object<gdk_sys::GdkWindow, gdk_sys::GdkWindowClass, WindowClass>);

    match fn {
        get_type => || gdk_sys::gdk_window_get_type(),
    }
}

impl Window {
    pub fn constrain_size(
        geometry: &mut Geometry,
        flags: WindowHints,
        width: i32,
        height: i32,
    ) -> (i32, i32) {
        assert_initialized_main_thread!();
        unsafe {
            let mut new_width = mem::MaybeUninit::uninit();
            let mut new_height = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_constrain_size(
                geometry.to_glib_none_mut().0,
                flags.to_glib(),
                width,
                height,
                new_width.as_mut_ptr(),
                new_height.as_mut_ptr(),
            );
            let new_width = new_width.assume_init();
            let new_height = new_height.assume_init();
            (new_width, new_height)
        }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn process_all_updates() {
        assert_initialized_main_thread!();
        unsafe {
            gdk_sys::gdk_window_process_all_updates();
        }
    }

    #[cfg_attr(feature = "v3_22", deprecated)]
    pub fn set_debug_updates(setting: bool) {
        assert_initialized_main_thread!();
        unsafe {
            gdk_sys::gdk_window_set_debug_updates(setting.to_glib());
        }
    }
}

pub const NONE_WINDOW: Option<&Window> = None;

pub trait WindowExt: 'static {
    //fn add_filter(&self, function: /*Unimplemented*/Fn(/*Unimplemented*/XEvent, &Event) -> /*Ignored*/FilterReturn, data: /*Unimplemented*/Option<Fundamental: Pointer>);

    fn beep(&self);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn begin_draw_frame(&self, region: &cairo::Region) -> Option<DrawingContext>;

    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32);

    fn begin_move_drag_for_device(
        &self,
        device: &Device,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    );

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn begin_paint_rect(&self, rectangle: &Rectangle);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn begin_paint_region(&self, region: &cairo::Region);

    fn begin_resize_drag(
        &self,
        edge: WindowEdge,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    );

    fn begin_resize_drag_for_device(
        &self,
        edge: WindowEdge,
        device: &Device,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    );

    fn coords_from_parent(&self, parent_x: f64, parent_y: f64) -> (f64, f64);

    fn coords_to_parent(&self, x: f64, y: f64) -> (f64, f64);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn create_gl_context(&self) -> Result<GLContext, glib::Error>;

    fn create_similar_image_surface(
        &self,
        format: i32,
        width: i32,
        height: i32,
        scale: i32,
    ) -> Option<cairo::Surface>;

    fn deiconify(&self);

    fn destroy(&self);

    fn destroy_notify(&self);

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn end_draw_frame(&self, context: &DrawingContext);

    fn end_paint(&self);

    fn ensure_native(&self) -> bool;

    fn focus(&self, timestamp: u32);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn freeze_toplevel_updates_libgtk_only(&self);

    fn freeze_updates(&self);

    fn fullscreen(&self);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn fullscreen_on_monitor(&self, monitor: i32);

    fn geometry_changed(&self);

    fn get_accept_focus(&self) -> bool;

    fn get_children(&self) -> Vec<Window>;

    //fn get_children_with_user_data(&self, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> Vec<Window>;

    fn get_clip_region(&self) -> Option<cairo::Region>;

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn get_composited(&self) -> bool;

    fn get_cursor(&self) -> Option<Cursor>;

    fn get_decorations(&self) -> Option<WMDecoration>;

    fn get_device_cursor(&self, device: &Device) -> Option<Cursor>;

    fn get_device_events(&self, device: &Device) -> EventMask;

    fn get_device_position(&self, device: &Device) -> (Option<Window>, i32, i32, ModifierType);

    fn get_device_position_double(
        &self,
        device: &Device,
    ) -> (Option<Window>, f64, f64, ModifierType);

    fn get_display(&self) -> Display;

    fn get_drag_protocol(&self) -> (DragProtocol, Window);

    fn get_effective_parent(&self) -> Option<Window>;

    fn get_effective_toplevel(&self) -> Window;

    fn get_event_compression(&self) -> bool;

    fn get_events(&self) -> EventMask;

    fn get_focus_on_map(&self) -> bool;

    fn get_frame_clock(&self) -> Option<FrameClock>;

    fn get_frame_extents(&self) -> Rectangle;

    fn get_fullscreen_mode(&self) -> FullscreenMode;

    fn get_geometry(&self) -> (i32, i32, i32, i32);

    fn get_group(&self) -> Option<Window>;

    fn get_height(&self) -> i32;

    fn get_modal_hint(&self) -> bool;

    fn get_origin(&self) -> (i32, i32, i32);

    fn get_parent(&self) -> Option<Window>;

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_pass_through(&self) -> bool;

    fn get_position(&self) -> (i32, i32);

    fn get_root_coords(&self, x: i32, y: i32) -> (i32, i32);

    fn get_root_origin(&self) -> (i32, i32);

    fn get_scale_factor(&self) -> i32;

    fn get_screen(&self) -> Screen;

    fn get_source_events(&self, source: InputSource) -> EventMask;

    fn get_state(&self) -> WindowState;

    fn get_support_multidevice(&self) -> bool;

    fn get_toplevel(&self) -> Window;

    fn get_type_hint(&self) -> WindowTypeHint;

    fn get_update_area(&self) -> Option<cairo::Region>;

    fn get_visible_region(&self) -> Option<cairo::Region>;

    fn get_visual(&self) -> Visual;

    fn get_width(&self) -> i32;

    fn get_window_type(&self) -> WindowType;

    fn has_native(&self) -> bool;

    fn hide(&self);

    fn iconify(&self);

    fn input_shape_combine_region(
        &self,
        shape_region: &cairo::Region,
        offset_x: i32,
        offset_y: i32,
    );

    fn invalidate_maybe_recurse(
        &self,
        region: &cairo::Region,
        child_func: Option<&mut dyn (FnMut(&Window) -> bool)>,
    );

    fn invalidate_rect(&self, rect: Option<&Rectangle>, invalidate_children: bool);

    fn invalidate_region(&self, region: &cairo::Region, invalidate_children: bool);

    fn is_destroyed(&self) -> bool;

    fn is_input_only(&self) -> bool;

    fn is_shaped(&self) -> bool;

    fn is_viewable(&self) -> bool;

    fn is_visible(&self) -> bool;

    fn lower(&self);

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn mark_paint_from_clip(&self, cr: &cairo::Context);

    fn maximize(&self);

    fn merge_child_input_shapes(&self);

    fn merge_child_shapes(&self);

    fn move_(&self, x: i32, y: i32);

    fn move_region(&self, region: &cairo::Region, dx: i32, dy: i32);

    fn move_resize(&self, x: i32, y: i32, width: i32, height: i32);

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    fn move_to_rect(
        &self,
        rect: &Rectangle,
        rect_anchor: Gravity,
        window_anchor: Gravity,
        anchor_hints: AnchorHints,
        rect_anchor_dx: i32,
        rect_anchor_dy: i32,
    );

    fn peek_children(&self) -> Vec<Window>;

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn process_updates(&self, update_children: bool);

    fn raise(&self);

    fn register_dnd(&self);

    //fn remove_filter(&self, function: /*Unimplemented*/Fn(/*Unimplemented*/XEvent, &Event) -> /*Ignored*/FilterReturn, data: /*Unimplemented*/Option<Fundamental: Pointer>);

    fn reparent<P: IsA<Window>>(&self, new_parent: &P, x: i32, y: i32);

    fn resize(&self, width: i32, height: i32);

    fn restack<P: IsA<Window>>(&self, sibling: Option<&P>, above: bool);

    fn scroll(&self, dx: i32, dy: i32);

    fn set_accept_focus(&self, accept_focus: bool);

    #[cfg_attr(feature = "v3_22", deprecated)]
    fn set_background_rgba(&self, rgba: &RGBA);

    fn set_child_input_shapes(&self);

    fn set_child_shapes(&self);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn set_composited(&self, composited: bool);

    fn set_cursor(&self, cursor: Option<&Cursor>);

    fn set_decorations(&self, decorations: WMDecoration);

    fn set_device_cursor(&self, device: &Device, cursor: &Cursor);

    fn set_device_events(&self, device: &Device, event_mask: EventMask);

    fn set_event_compression(&self, event_compression: bool);

    fn set_events(&self, event_mask: EventMask);

    fn set_focus_on_map(&self, focus_on_map: bool);

    fn set_fullscreen_mode(&self, mode: FullscreenMode);

    fn set_functions(&self, functions: WMFunction);

    fn set_geometry_hints(&self, geometry: &Geometry, geom_mask: WindowHints);

    fn set_group<P: IsA<Window>>(&self, leader: Option<&P>);

    fn set_icon_list(&self, pixbufs: &[gdk_pixbuf::Pixbuf]);

    fn set_icon_name(&self, name: Option<&str>);

    //fn set_invalidate_handler<P: Fn(&Window, &cairo::Region) + 'static>(&self, handler: P);

    fn set_keep_above(&self, setting: bool);

    fn set_keep_below(&self, setting: bool);

    fn set_modal_hint(&self, modal: bool);

    fn set_opacity(&self, opacity: f64);

    fn set_opaque_region(&self, region: Option<&cairo::Region>);

    fn set_override_redirect(&self, override_redirect: bool);

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_pass_through(&self, pass_through: bool);

    fn set_role(&self, role: &str);

    fn set_shadow_width(&self, left: i32, right: i32, top: i32, bottom: i32);

    fn set_skip_pager_hint(&self, skips_pager: bool);

    fn set_skip_taskbar_hint(&self, skips_taskbar: bool);

    fn set_source_events(&self, source: InputSource, event_mask: EventMask);

    fn set_startup_id(&self, startup_id: &str);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn set_static_gravities(&self, use_static: bool) -> bool;

    fn set_support_multidevice(&self, support_multidevice: bool);

    fn set_title(&self, title: &str);

    fn set_transient_for<P: IsA<Window>>(&self, parent: &P);

    fn set_type_hint(&self, hint: WindowTypeHint);

    fn set_urgency_hint(&self, urgent: bool);

    fn shape_combine_region(
        &self,
        shape_region: Option<&cairo::Region>,
        offset_x: i32,
        offset_y: i32,
    );

    fn show(&self);

    fn show_unraised(&self);

    fn show_window_menu(&self, event: &mut Event) -> bool;

    fn stick(&self);

    #[cfg_attr(feature = "v3_16", deprecated)]
    fn thaw_toplevel_updates_libgtk_only(&self);

    fn thaw_updates(&self);

    fn unfullscreen(&self);

    fn unmaximize(&self);

    fn unstick(&self);

    fn withdraw(&self);

    fn connect_create_surface<F: Fn(&Self, i32, i32) -> cairo::Surface + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    //fn connect_from_embedder<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    //#[cfg(any(feature = "v3_22", feature = "dox"))]
    //fn connect_moved_to_rect<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    fn connect_pick_embedded_child<F: Fn(&Self, f64, f64) -> Option<Window> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    //fn connect_to_embedder<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    fn connect_property_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Window>> WindowExt for O {
    //fn add_filter(&self, function: /*Unimplemented*/Fn(/*Unimplemented*/XEvent, &Event) -> /*Ignored*/FilterReturn, data: /*Unimplemented*/Option<Fundamental: Pointer>) {
    //    unsafe { TODO: call gdk_sys:gdk_window_add_filter() }
    //}

    fn beep(&self) {
        unsafe {
            gdk_sys::gdk_window_beep(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn begin_draw_frame(&self, region: &cairo::Region) -> Option<DrawingContext> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_begin_draw_frame(
                self.as_ref().to_glib_none().0,
                region.to_glib_none().0,
            ))
        }
    }

    fn begin_move_drag(&self, button: i32, root_x: i32, root_y: i32, timestamp: u32) {
        unsafe {
            gdk_sys::gdk_window_begin_move_drag(
                self.as_ref().to_glib_none().0,
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    fn begin_move_drag_for_device(
        &self,
        device: &Device,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    ) {
        unsafe {
            gdk_sys::gdk_window_begin_move_drag_for_device(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    fn begin_paint_rect(&self, rectangle: &Rectangle) {
        unsafe {
            gdk_sys::gdk_window_begin_paint_rect(
                self.as_ref().to_glib_none().0,
                rectangle.to_glib_none().0,
            );
        }
    }

    fn begin_paint_region(&self, region: &cairo::Region) {
        unsafe {
            gdk_sys::gdk_window_begin_paint_region(
                self.as_ref().to_glib_none().0,
                region.to_glib_none().0,
            );
        }
    }

    fn begin_resize_drag(
        &self,
        edge: WindowEdge,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    ) {
        unsafe {
            gdk_sys::gdk_window_begin_resize_drag(
                self.as_ref().to_glib_none().0,
                edge.to_glib(),
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    fn begin_resize_drag_for_device(
        &self,
        edge: WindowEdge,
        device: &Device,
        button: i32,
        root_x: i32,
        root_y: i32,
        timestamp: u32,
    ) {
        unsafe {
            gdk_sys::gdk_window_begin_resize_drag_for_device(
                self.as_ref().to_glib_none().0,
                edge.to_glib(),
                device.to_glib_none().0,
                button,
                root_x,
                root_y,
                timestamp,
            );
        }
    }

    fn coords_from_parent(&self, parent_x: f64, parent_y: f64) -> (f64, f64) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_coords_from_parent(
                self.as_ref().to_glib_none().0,
                parent_x,
                parent_y,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            (x, y)
        }
    }

    fn coords_to_parent(&self, x: f64, y: f64) -> (f64, f64) {
        unsafe {
            let mut parent_x = mem::MaybeUninit::uninit();
            let mut parent_y = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_coords_to_parent(
                self.as_ref().to_glib_none().0,
                x,
                y,
                parent_x.as_mut_ptr(),
                parent_y.as_mut_ptr(),
            );
            let parent_x = parent_x.assume_init();
            let parent_y = parent_y.assume_init();
            (parent_x, parent_y)
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn create_gl_context(&self) -> Result<GLContext, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret =
                gdk_sys::gdk_window_create_gl_context(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn create_similar_image_surface(
        &self,
        format: i32,
        width: i32,
        height: i32,
        scale: i32,
    ) -> Option<cairo::Surface> {
        unsafe {
            from_glib_full(gdk_sys::gdk_window_create_similar_image_surface(
                self.as_ref().to_glib_none().0,
                format,
                width,
                height,
                scale,
            ))
        }
    }

    fn deiconify(&self) {
        unsafe {
            gdk_sys::gdk_window_deiconify(self.as_ref().to_glib_none().0);
        }
    }

    fn destroy(&self) {
        unsafe {
            gdk_sys::gdk_window_destroy(self.as_ref().to_glib_none().0);
        }
    }

    fn destroy_notify(&self) {
        unsafe {
            gdk_sys::gdk_window_destroy_notify(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_22", feature = "dox"))]
    fn end_draw_frame(&self, context: &DrawingContext) {
        unsafe {
            gdk_sys::gdk_window_end_draw_frame(
                self.as_ref().to_glib_none().0,
                context.to_glib_none().0,
            );
        }
    }

    fn end_paint(&self) {
        unsafe {
            gdk_sys::gdk_window_end_paint(self.as_ref().to_glib_none().0);
        }
    }

    fn ensure_native(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_ensure_native(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn focus(&self, timestamp: u32) {
        unsafe {
            gdk_sys::gdk_window_focus(self.as_ref().to_glib_none().0, timestamp);
        }
    }

    fn freeze_toplevel_updates_libgtk_only(&self) {
        unsafe {
            gdk_sys::gdk_window_freeze_toplevel_updates_libgtk_only(self.as_ref().to_glib_none().0);
        }
    }

    fn freeze_updates(&self) {
        unsafe {
            gdk_sys::gdk_window_freeze_updates(self.as_ref().to_glib_none().0);
        }
    }

    fn fullscreen(&self) {
        unsafe {
            gdk_sys::gdk_window_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn fullscreen_on_monitor(&self, monitor: i32) {
        unsafe {
            gdk_sys::gdk_window_fullscreen_on_monitor(self.as_ref().to_glib_none().0, monitor);
        }
    }

    fn geometry_changed(&self) {
        unsafe {
            gdk_sys::gdk_window_geometry_changed(self.as_ref().to_glib_none().0);
        }
    }

    fn get_accept_focus(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_accept_focus(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_children(&self) -> Vec<Window> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(gdk_sys::gdk_window_get_children(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn get_children_with_user_data(&self, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> Vec<Window> {
    //    unsafe { TODO: call gdk_sys:gdk_window_get_children_with_user_data() }
    //}

    fn get_clip_region(&self) -> Option<cairo::Region> {
        unsafe {
            from_glib_full(gdk_sys::gdk_window_get_clip_region(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_composited(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_composited(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_cursor(&self) -> Option<Cursor> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_cursor(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_decorations(&self) -> Option<WMDecoration> {
        unsafe {
            let mut decorations = mem::MaybeUninit::uninit();
            let ret = from_glib(gdk_sys::gdk_window_get_decorations(
                self.as_ref().to_glib_none().0,
                decorations.as_mut_ptr(),
            ));
            let decorations = decorations.assume_init();
            if ret {
                Some(from_glib(decorations))
            } else {
                None
            }
        }
    }

    fn get_device_cursor(&self, device: &Device) -> Option<Cursor> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_device_cursor(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
            ))
        }
    }

    fn get_device_events(&self, device: &Device) -> EventMask {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_device_events(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
            ))
        }
    }

    fn get_device_position(&self, device: &Device) -> (Option<Window>, i32, i32, ModifierType) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let mut mask = mem::MaybeUninit::uninit();
            let ret = from_glib_none(gdk_sys::gdk_window_get_device_position(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
                mask.as_mut_ptr(),
            ));
            let x = x.assume_init();
            let y = y.assume_init();
            let mask = mask.assume_init();
            (ret, x, y, from_glib(mask))
        }
    }

    fn get_device_position_double(
        &self,
        device: &Device,
    ) -> (Option<Window>, f64, f64, ModifierType) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let mut mask = mem::MaybeUninit::uninit();
            let ret = from_glib_none(gdk_sys::gdk_window_get_device_position_double(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
                mask.as_mut_ptr(),
            ));
            let x = x.assume_init();
            let y = y.assume_init();
            let mask = mask.assume_init();
            (ret, x, y, from_glib(mask))
        }
    }

    fn get_display(&self) -> Display {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_display(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_drag_protocol(&self) -> (DragProtocol, Window) {
        unsafe {
            let mut target = ptr::null_mut();
            let ret = from_glib(gdk_sys::gdk_window_get_drag_protocol(
                self.as_ref().to_glib_none().0,
                &mut target,
            ));
            (ret, from_glib_full(target))
        }
    }

    fn get_effective_parent(&self) -> Option<Window> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_effective_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_effective_toplevel(&self) -> Window {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_effective_toplevel(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_event_compression(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_event_compression(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_events(&self) -> EventMask {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_events(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_focus_on_map(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_focus_on_map(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_frame_clock(&self) -> Option<FrameClock> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_frame_clock(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_frame_extents(&self) -> Rectangle {
        unsafe {
            let mut rect = Rectangle::uninitialized();
            gdk_sys::gdk_window_get_frame_extents(
                self.as_ref().to_glib_none().0,
                rect.to_glib_none_mut().0,
            );
            rect
        }
    }

    fn get_fullscreen_mode(&self) -> FullscreenMode {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_fullscreen_mode(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_geometry(&self) -> (i32, i32, i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let mut width = mem::MaybeUninit::uninit();
            let mut height = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_get_geometry(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
                width.as_mut_ptr(),
                height.as_mut_ptr(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            let width = width.assume_init();
            let height = height.assume_init();
            (x, y, width, height)
        }
    }

    fn get_group(&self) -> Option<Window> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_group(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_height(&self) -> i32 {
        unsafe { gdk_sys::gdk_window_get_height(self.as_ref().to_glib_none().0) }
    }

    fn get_modal_hint(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_modal_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_origin(&self) -> (i32, i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            let ret = gdk_sys::gdk_window_get_origin(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            (ret, x, y)
        }
    }

    fn get_parent(&self) -> Option<Window> {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_parent(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn get_pass_through(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_pass_through(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_position(&self) -> (i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_get_position(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            (x, y)
        }
    }

    fn get_root_coords(&self, x: i32, y: i32) -> (i32, i32) {
        unsafe {
            let mut root_x = mem::MaybeUninit::uninit();
            let mut root_y = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_get_root_coords(
                self.as_ref().to_glib_none().0,
                x,
                y,
                root_x.as_mut_ptr(),
                root_y.as_mut_ptr(),
            );
            let root_x = root_x.assume_init();
            let root_y = root_y.assume_init();
            (root_x, root_y)
        }
    }

    fn get_root_origin(&self) -> (i32, i32) {
        unsafe {
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            gdk_sys::gdk_window_get_root_origin(
                self.as_ref().to_glib_none().0,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            let x = x.assume_init();
            let y = y.assume_init();
            (x, y)
        }
    }

    fn get_scale_factor(&self) -> i32 {
        unsafe { gdk_sys::gdk_window_get_scale_factor(self.as_ref().to_glib_none().0) }
    }

    fn get_screen(&self) -> Screen {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_screen(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_source_events(&self, source: InputSource) -> EventMask {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_source_events(
                self.as_ref().to_glib_none().0,
                source.to_glib(),
            ))
        }
    }

    fn get_state(&self) -> WindowState {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_state(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_support_multidevice(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_support_multidevice(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_toplevel(&self) -> Window {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_toplevel(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_type_hint(&self) -> WindowTypeHint {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_type_hint(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_update_area(&self) -> Option<cairo::Region> {
        unsafe {
            from_glib_full(gdk_sys::gdk_window_get_update_area(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_visible_region(&self) -> Option<cairo::Region> {
        unsafe {
            from_glib_full(gdk_sys::gdk_window_get_visible_region(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_visual(&self) -> Visual {
        unsafe {
            from_glib_none(gdk_sys::gdk_window_get_visual(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_width(&self) -> i32 {
        unsafe { gdk_sys::gdk_window_get_width(self.as_ref().to_glib_none().0) }
    }

    fn get_window_type(&self) -> WindowType {
        unsafe {
            from_glib(gdk_sys::gdk_window_get_window_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn has_native(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_has_native(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn hide(&self) {
        unsafe {
            gdk_sys::gdk_window_hide(self.as_ref().to_glib_none().0);
        }
    }

    fn iconify(&self) {
        unsafe {
            gdk_sys::gdk_window_iconify(self.as_ref().to_glib_none().0);
        }
    }

    fn input_shape_combine_region(
        &self,
        shape_region: &cairo::Region,
        offset_x: i32,
        offset_y: i32,
    ) {
        unsafe {
            gdk_sys::gdk_window_input_shape_combine_region(
                self.as_ref().to_glib_none().0,
                shape_region.to_glib_none().0,
                offset_x,
                offset_y,
            );
        }
    }

    fn invalidate_maybe_recurse(
        &self,
        region: &cairo::Region,
        child_func: Option<&mut dyn (FnMut(&Window) -> bool)>,
    ) {
        let child_func_data: Option<&mut dyn (FnMut(&Window) -> bool)> = child_func;
        unsafe extern "C" fn child_func_func(
            window: *mut gdk_sys::GdkWindow,
            user_data: glib_sys::gpointer,
        ) -> glib_sys::gboolean {
            let window = from_glib_borrow(window);
            let callback: *mut Option<&mut dyn (FnMut(&Window) -> bool)> =
                user_data as *const _ as usize as *mut Option<&mut dyn (FnMut(&Window) -> bool)>;
            let res = if let Some(ref mut callback) = *callback {
                callback(&window)
            } else {
                panic!("cannot get closure...")
            };
            res.to_glib()
        }
        let child_func = if child_func_data.is_some() {
            Some(child_func_func as _)
        } else {
            None
        };
        let super_callback0: &Option<&mut dyn (FnMut(&Window) -> bool)> = &child_func_data;
        unsafe {
            gdk_sys::gdk_window_invalidate_maybe_recurse(
                self.as_ref().to_glib_none().0,
                region.to_glib_none().0,
                child_func,
                super_callback0 as *const _ as usize as *mut _,
            );
        }
    }

    fn invalidate_rect(&self, rect: Option<&Rectangle>, invalidate_children: bool) {
        unsafe {
            gdk_sys::gdk_window_invalidate_rect(
                self.as_ref().to_glib_none().0,
                rect.to_glib_none().0,
                invalidate_children.to_glib(),
            );
        }
    }

    fn invalidate_region(&self, region: &cairo::Region, invalidate_children: bool) {
        unsafe {
            gdk_sys::gdk_window_invalidate_region(
                self.as_ref().to_glib_none().0,
                region.to_glib_none().0,
                invalidate_children.to_glib(),
            );
        }
    }

    fn is_destroyed(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_is_destroyed(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_input_only(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_is_input_only(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_shaped(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_is_shaped(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_viewable(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_is_viewable(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_visible(&self) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_is_visible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn lower(&self) {
        unsafe {
            gdk_sys::gdk_window_lower(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v3_16", feature = "dox"))]
    fn mark_paint_from_clip(&self, cr: &cairo::Context) {
        unsafe {
            gdk_sys::gdk_window_mark_paint_from_clip(
                self.as_ref().to_glib_none().0,
                mut_override(cr.to_glib_none().0),
            );
        }
    }

    fn maximize(&self) {
        unsafe {
            gdk_sys::gdk_window_maximize(self.as_ref().to_glib_none().0);
        }
    }

    fn merge_child_input_shapes(&self) {
        unsafe {
            gdk_sys::gdk_window_merge_child_input_shapes(self.as_ref().to_glib_none().0);
        }
    }

    fn merge_child_shapes(&self) {
        unsafe {
            gdk_sys::gdk_window_merge_child_shapes(self.as_ref().to_glib_none().0);
        }
    }

    fn move_(&self, x: i32, y: i32) {
        unsafe {
            gdk_sys::gdk_window_move(self.as_ref().to_glib_none().0, x, y);
        }
    }

    fn move_region(&self, region: &cairo::Region, dx: i32, dy: i32) {
        unsafe {
            gdk_sys::gdk_window_move_region(
                self.as_ref().to_glib_none().0,
                region.to_glib_none().0,
                dx,
                dy,
            );
        }
    }

    fn move_resize(&self, x: i32, y: i32, width: i32, height: i32) {
        unsafe {
            gdk_sys::gdk_window_move_resize(self.as_ref().to_glib_none().0, x, y, width, height);
        }
    }

    #[cfg(any(feature = "v3_24", feature = "dox"))]
    fn move_to_rect(
        &self,
        rect: &Rectangle,
        rect_anchor: Gravity,
        window_anchor: Gravity,
        anchor_hints: AnchorHints,
        rect_anchor_dx: i32,
        rect_anchor_dy: i32,
    ) {
        unsafe {
            gdk_sys::gdk_window_move_to_rect(
                self.as_ref().to_glib_none().0,
                rect.to_glib_none().0,
                rect_anchor.to_glib(),
                window_anchor.to_glib(),
                anchor_hints.to_glib(),
                rect_anchor_dx,
                rect_anchor_dy,
            );
        }
    }

    fn peek_children(&self) -> Vec<Window> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(gdk_sys::gdk_window_peek_children(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn process_updates(&self, update_children: bool) {
        unsafe {
            gdk_sys::gdk_window_process_updates(
                self.as_ref().to_glib_none().0,
                update_children.to_glib(),
            );
        }
    }

    fn raise(&self) {
        unsafe {
            gdk_sys::gdk_window_raise(self.as_ref().to_glib_none().0);
        }
    }

    fn register_dnd(&self) {
        unsafe {
            gdk_sys::gdk_window_register_dnd(self.as_ref().to_glib_none().0);
        }
    }

    //fn remove_filter(&self, function: /*Unimplemented*/Fn(/*Unimplemented*/XEvent, &Event) -> /*Ignored*/FilterReturn, data: /*Unimplemented*/Option<Fundamental: Pointer>) {
    //    unsafe { TODO: call gdk_sys:gdk_window_remove_filter() }
    //}

    fn reparent<P: IsA<Window>>(&self, new_parent: &P, x: i32, y: i32) {
        unsafe {
            gdk_sys::gdk_window_reparent(
                self.as_ref().to_glib_none().0,
                new_parent.as_ref().to_glib_none().0,
                x,
                y,
            );
        }
    }

    fn resize(&self, width: i32, height: i32) {
        unsafe {
            gdk_sys::gdk_window_resize(self.as_ref().to_glib_none().0, width, height);
        }
    }

    fn restack<P: IsA<Window>>(&self, sibling: Option<&P>, above: bool) {
        unsafe {
            gdk_sys::gdk_window_restack(
                self.as_ref().to_glib_none().0,
                sibling.map(|p| p.as_ref()).to_glib_none().0,
                above.to_glib(),
            );
        }
    }

    fn scroll(&self, dx: i32, dy: i32) {
        unsafe {
            gdk_sys::gdk_window_scroll(self.as_ref().to_glib_none().0, dx, dy);
        }
    }

    fn set_accept_focus(&self, accept_focus: bool) {
        unsafe {
            gdk_sys::gdk_window_set_accept_focus(
                self.as_ref().to_glib_none().0,
                accept_focus.to_glib(),
            );
        }
    }

    fn set_background_rgba(&self, rgba: &RGBA) {
        unsafe {
            gdk_sys::gdk_window_set_background_rgba(
                self.as_ref().to_glib_none().0,
                rgba.to_glib_none().0,
            );
        }
    }

    fn set_child_input_shapes(&self) {
        unsafe {
            gdk_sys::gdk_window_set_child_input_shapes(self.as_ref().to_glib_none().0);
        }
    }

    fn set_child_shapes(&self) {
        unsafe {
            gdk_sys::gdk_window_set_child_shapes(self.as_ref().to_glib_none().0);
        }
    }

    fn set_composited(&self, composited: bool) {
        unsafe {
            gdk_sys::gdk_window_set_composited(
                self.as_ref().to_glib_none().0,
                composited.to_glib(),
            );
        }
    }

    fn set_cursor(&self, cursor: Option<&Cursor>) {
        unsafe {
            gdk_sys::gdk_window_set_cursor(self.as_ref().to_glib_none().0, cursor.to_glib_none().0);
        }
    }

    fn set_decorations(&self, decorations: WMDecoration) {
        unsafe {
            gdk_sys::gdk_window_set_decorations(
                self.as_ref().to_glib_none().0,
                decorations.to_glib(),
            );
        }
    }

    fn set_device_cursor(&self, device: &Device, cursor: &Cursor) {
        unsafe {
            gdk_sys::gdk_window_set_device_cursor(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                cursor.to_glib_none().0,
            );
        }
    }

    fn set_device_events(&self, device: &Device, event_mask: EventMask) {
        unsafe {
            gdk_sys::gdk_window_set_device_events(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
                event_mask.to_glib(),
            );
        }
    }

    fn set_event_compression(&self, event_compression: bool) {
        unsafe {
            gdk_sys::gdk_window_set_event_compression(
                self.as_ref().to_glib_none().0,
                event_compression.to_glib(),
            );
        }
    }

    fn set_events(&self, event_mask: EventMask) {
        unsafe {
            gdk_sys::gdk_window_set_events(self.as_ref().to_glib_none().0, event_mask.to_glib());
        }
    }

    fn set_focus_on_map(&self, focus_on_map: bool) {
        unsafe {
            gdk_sys::gdk_window_set_focus_on_map(
                self.as_ref().to_glib_none().0,
                focus_on_map.to_glib(),
            );
        }
    }

    fn set_fullscreen_mode(&self, mode: FullscreenMode) {
        unsafe {
            gdk_sys::gdk_window_set_fullscreen_mode(self.as_ref().to_glib_none().0, mode.to_glib());
        }
    }

    fn set_functions(&self, functions: WMFunction) {
        unsafe {
            gdk_sys::gdk_window_set_functions(self.as_ref().to_glib_none().0, functions.to_glib());
        }
    }

    fn set_geometry_hints(&self, geometry: &Geometry, geom_mask: WindowHints) {
        unsafe {
            gdk_sys::gdk_window_set_geometry_hints(
                self.as_ref().to_glib_none().0,
                geometry.to_glib_none().0,
                geom_mask.to_glib(),
            );
        }
    }

    fn set_group<P: IsA<Window>>(&self, leader: Option<&P>) {
        unsafe {
            gdk_sys::gdk_window_set_group(
                self.as_ref().to_glib_none().0,
                leader.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_icon_list(&self, pixbufs: &[gdk_pixbuf::Pixbuf]) {
        unsafe {
            gdk_sys::gdk_window_set_icon_list(
                self.as_ref().to_glib_none().0,
                pixbufs.to_glib_none().0,
            );
        }
    }

    fn set_icon_name(&self, name: Option<&str>) {
        unsafe {
            gdk_sys::gdk_window_set_icon_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    //fn set_invalidate_handler<P: Fn(&Window, &cairo::Region) + 'static>(&self, handler: P) {
    //    unsafe { TODO: call gdk_sys:gdk_window_set_invalidate_handler() }
    //}

    fn set_keep_above(&self, setting: bool) {
        unsafe {
            gdk_sys::gdk_window_set_keep_above(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_keep_below(&self, setting: bool) {
        unsafe {
            gdk_sys::gdk_window_set_keep_below(self.as_ref().to_glib_none().0, setting.to_glib());
        }
    }

    fn set_modal_hint(&self, modal: bool) {
        unsafe {
            gdk_sys::gdk_window_set_modal_hint(self.as_ref().to_glib_none().0, modal.to_glib());
        }
    }

    fn set_opacity(&self, opacity: f64) {
        unsafe {
            gdk_sys::gdk_window_set_opacity(self.as_ref().to_glib_none().0, opacity);
        }
    }

    fn set_opaque_region(&self, region: Option<&cairo::Region>) {
        unsafe {
            gdk_sys::gdk_window_set_opaque_region(
                self.as_ref().to_glib_none().0,
                mut_override(region.to_glib_none().0),
            );
        }
    }

    fn set_override_redirect(&self, override_redirect: bool) {
        unsafe {
            gdk_sys::gdk_window_set_override_redirect(
                self.as_ref().to_glib_none().0,
                override_redirect.to_glib(),
            );
        }
    }

    #[cfg(any(feature = "v3_18", feature = "dox"))]
    fn set_pass_through(&self, pass_through: bool) {
        unsafe {
            gdk_sys::gdk_window_set_pass_through(
                self.as_ref().to_glib_none().0,
                pass_through.to_glib(),
            );
        }
    }

    fn set_role(&self, role: &str) {
        unsafe {
            gdk_sys::gdk_window_set_role(self.as_ref().to_glib_none().0, role.to_glib_none().0);
        }
    }

    fn set_shadow_width(&self, left: i32, right: i32, top: i32, bottom: i32) {
        unsafe {
            gdk_sys::gdk_window_set_shadow_width(
                self.as_ref().to_glib_none().0,
                left,
                right,
                top,
                bottom,
            );
        }
    }

    fn set_skip_pager_hint(&self, skips_pager: bool) {
        unsafe {
            gdk_sys::gdk_window_set_skip_pager_hint(
                self.as_ref().to_glib_none().0,
                skips_pager.to_glib(),
            );
        }
    }

    fn set_skip_taskbar_hint(&self, skips_taskbar: bool) {
        unsafe {
            gdk_sys::gdk_window_set_skip_taskbar_hint(
                self.as_ref().to_glib_none().0,
                skips_taskbar.to_glib(),
            );
        }
    }

    fn set_source_events(&self, source: InputSource, event_mask: EventMask) {
        unsafe {
            gdk_sys::gdk_window_set_source_events(
                self.as_ref().to_glib_none().0,
                source.to_glib(),
                event_mask.to_glib(),
            );
        }
    }

    fn set_startup_id(&self, startup_id: &str) {
        unsafe {
            gdk_sys::gdk_window_set_startup_id(
                self.as_ref().to_glib_none().0,
                startup_id.to_glib_none().0,
            );
        }
    }

    fn set_static_gravities(&self, use_static: bool) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_set_static_gravities(
                self.as_ref().to_glib_none().0,
                use_static.to_glib(),
            ))
        }
    }

    fn set_support_multidevice(&self, support_multidevice: bool) {
        unsafe {
            gdk_sys::gdk_window_set_support_multidevice(
                self.as_ref().to_glib_none().0,
                support_multidevice.to_glib(),
            );
        }
    }

    fn set_title(&self, title: &str) {
        unsafe {
            gdk_sys::gdk_window_set_title(self.as_ref().to_glib_none().0, title.to_glib_none().0);
        }
    }

    fn set_transient_for<P: IsA<Window>>(&self, parent: &P) {
        unsafe {
            gdk_sys::gdk_window_set_transient_for(
                self.as_ref().to_glib_none().0,
                parent.as_ref().to_glib_none().0,
            );
        }
    }

    fn set_type_hint(&self, hint: WindowTypeHint) {
        unsafe {
            gdk_sys::gdk_window_set_type_hint(self.as_ref().to_glib_none().0, hint.to_glib());
        }
    }

    fn set_urgency_hint(&self, urgent: bool) {
        unsafe {
            gdk_sys::gdk_window_set_urgency_hint(self.as_ref().to_glib_none().0, urgent.to_glib());
        }
    }

    fn shape_combine_region(
        &self,
        shape_region: Option<&cairo::Region>,
        offset_x: i32,
        offset_y: i32,
    ) {
        unsafe {
            gdk_sys::gdk_window_shape_combine_region(
                self.as_ref().to_glib_none().0,
                shape_region.to_glib_none().0,
                offset_x,
                offset_y,
            );
        }
    }

    fn show(&self) {
        unsafe {
            gdk_sys::gdk_window_show(self.as_ref().to_glib_none().0);
        }
    }

    fn show_unraised(&self) {
        unsafe {
            gdk_sys::gdk_window_show_unraised(self.as_ref().to_glib_none().0);
        }
    }

    fn show_window_menu(&self, event: &mut Event) -> bool {
        unsafe {
            from_glib(gdk_sys::gdk_window_show_window_menu(
                self.as_ref().to_glib_none().0,
                event.to_glib_none_mut().0,
            ))
        }
    }

    fn stick(&self) {
        unsafe {
            gdk_sys::gdk_window_stick(self.as_ref().to_glib_none().0);
        }
    }

    fn thaw_toplevel_updates_libgtk_only(&self) {
        unsafe {
            gdk_sys::gdk_window_thaw_toplevel_updates_libgtk_only(self.as_ref().to_glib_none().0);
        }
    }

    fn thaw_updates(&self) {
        unsafe {
            gdk_sys::gdk_window_thaw_updates(self.as_ref().to_glib_none().0);
        }
    }

    fn unfullscreen(&self) {
        unsafe {
            gdk_sys::gdk_window_unfullscreen(self.as_ref().to_glib_none().0);
        }
    }

    fn unmaximize(&self) {
        unsafe {
            gdk_sys::gdk_window_unmaximize(self.as_ref().to_glib_none().0);
        }
    }

    fn unstick(&self) {
        unsafe {
            gdk_sys::gdk_window_unstick(self.as_ref().to_glib_none().0);
        }
    }

    fn withdraw(&self) {
        unsafe {
            gdk_sys::gdk_window_withdraw(self.as_ref().to_glib_none().0);
        }
    }

    fn connect_create_surface<F: Fn(&Self, i32, i32) -> cairo::Surface + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn create_surface_trampoline<
            P,
            F: Fn(&P, i32, i32) -> cairo::Surface + 'static,
        >(
            this: *mut gdk_sys::GdkWindow,
            width: libc::c_int,
            height: libc::c_int,
            f: glib_sys::gpointer,
        ) -> *mut cairo_sys::cairo_surface_t
        where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(
                &Window::from_glib_borrow(this).unsafe_cast_ref(),
                width,
                height,
            )
            .to_glib_full()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"create-surface\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    create_surface_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //fn connect_from_embedder<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Out offscreen_x: *.Double
    //    Out offscreen_y: *.Double
    //}

    //#[cfg(any(feature = "v3_22", feature = "dox"))]
    //fn connect_moved_to_rect<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Unimplemented flipped_rect: *.Pointer
    //    Unimplemented final_rect: *.Pointer
    //}

    fn connect_pick_embedded_child<F: Fn(&Self, f64, f64) -> Option<Window> + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn pick_embedded_child_trampoline<
            P,
            F: Fn(&P, f64, f64) -> Option<Window> + 'static,
        >(
            this: *mut gdk_sys::GdkWindow,
            x: libc::c_double,
            y: libc::c_double,
            f: glib_sys::gpointer,
        ) -> *mut gdk_sys::GdkWindow
        where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast_ref(), x, y) /*Not checked*/
                .to_glib_none()
                .0
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"pick-embedded-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    pick_embedded_child_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    //fn connect_to_embedder<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Out embedder_x: *.Double
    //    Out embedder_y: *.Double
    //}

    fn connect_property_cursor_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_trampoline<P, F: Fn(&P) + 'static>(
            this: *mut gdk_sys::GdkWindow,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) where
            P: IsA<Window>,
        {
            let f: &F = &*(f as *const F);
            f(&Window::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Window {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Window")
    }
}
